/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.CompressorContainer;
import com.blakebr0.extendedcrafting.crafting.recipe.CompressorRecipe;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class CompressorTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private final BaseItemStackHandler inventory;
    private final BaseItemStackHandler recipeInventory;
    private final EnergyStorage energy;
    private final LazyOptional<IEnergyStorage> capability = LazyOptional.of(this::getEnergy);
    private CompressorRecipe recipe;
    private ItemStack materialStack = ItemStack.f_41583_;
    private int materialCount;
    private int progress;
    private boolean ejecting = false;
    private int oldEnergy;
    private boolean inputLimit = true;

    public CompressorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.COMPRESSOR.get(), pos, state);
        this.inventory = CompressorTileEntity.createInventoryHandler(null);
        this.recipeInventory = new BaseItemStackHandler(2);
        this.energy = new EnergyStorage(((Integer)ModConfigs.COMPRESSOR_POWER_CAPACITY.get()).intValue());
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.materialCount = tag.m_128451_("MaterialCount");
        this.materialStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("MaterialStack"));
        this.progress = tag.m_128451_("Progress");
        this.ejecting = tag.m_128471_("Ejecting");
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
        this.inputLimit = tag.m_128471_("InputLimit");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("MaterialCount", this.materialCount);
        tag.m_128365_("MaterialStack", (Tag)this.materialStack.serializeNBT());
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("Ejecting", this.ejecting);
        tag.m_128405_("Energy", this.energy.getEnergyStored());
        tag.m_128379_("InputLimit", this.inputLimit);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_() && cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, this.capability);
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.extendedcrafting.compressor").build();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        return CompressorContainer.create(windowId, playerInventory, arg_0 -> ((CompressorTileEntity)this).isUsableByPlayer(arg_0), this.inventory, (ContainerData)new SimpleContainerData(0), this.m_58899_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CompressorTileEntity tile) {
        boolean mark = false;
        ItemStack output = tile.inventory.getStackInSlot(0);
        ItemStack input = tile.inventory.getStackInSlot(1);
        ItemStack catalyst = tile.inventory.getStackInSlot(2);
        tile.recipeInventory.setStackInSlot(0, tile.materialStack);
        tile.recipeInventory.setStackInSlot(1, catalyst);
        if (tile.recipe == null || !tile.recipe.matches((IItemHandler)tile.recipeInventory)) {
            tile.recipe = level.m_7465_().m_44015_(RecipeTypes.COMPRESSOR, tile.recipeInventory.toIInventory(), level).orElse(null);
        }
        if (!level.m_5776_()) {
            int addCount;
            if (!input.m_41619_()) {
                if (tile.materialStack.m_41619_() || tile.materialCount <= 0) {
                    tile.materialStack = input.m_41777_();
                    mark = true;
                }
                if ((!tile.inputLimit || tile.recipe != null && tile.materialCount < tile.recipe.getInputCount()) && StackHelper.areStacksEqual((ItemStack)input, (ItemStack)tile.materialStack)) {
                    int consumeAmount = input.m_41613_();
                    if (tile.inputLimit) {
                        consumeAmount = Math.min(consumeAmount, tile.recipe.getInputCount() - tile.materialCount);
                    }
                    input.m_41774_(consumeAmount);
                    tile.materialCount += consumeAmount;
                    if (!mark) {
                        mark = true;
                    }
                }
            }
            if (tile.recipe != null && tile.getEnergy().getEnergyStored() > 0 && tile.materialCount >= tile.recipe.getInputCount()) {
                if (tile.progress >= tile.recipe.getPowerCost()) {
                    ItemStack result = tile.recipe.assemble((IItemHandler)tile.inventory);
                    if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)output)) {
                        tile.updateResult(result);
                        tile.progress = 0;
                        tile.materialCount -= tile.recipe.getInputCount();
                        if (tile.materialCount <= 0) {
                            tile.materialStack = ItemStack.f_41583_;
                        }
                    }
                } else {
                    tile.process(tile.recipe);
                }
            }
            if (tile.ejecting && tile.materialCount > 0 && !tile.materialStack.m_41619_() && (output.m_41619_() || StackHelper.areStacksEqual((ItemStack)tile.materialStack, (ItemStack)output)) && (addCount = Math.min(tile.materialCount, tile.materialStack.m_41741_() - output.m_41613_())) > 0) {
                ItemStack toAdd = StackHelper.withSize((ItemStack)tile.materialStack, (int)addCount, (boolean)false);
                tile.updateResult(toAdd);
                tile.materialCount -= addCount;
                if (tile.materialCount < 1) {
                    tile.materialStack = ItemStack.f_41583_;
                    tile.ejecting = false;
                }
                if (tile.progress > 0) {
                    tile.progress = 0;
                }
                if (!mark) {
                    mark = true;
                }
            }
        }
        if (tile.oldEnergy != tile.energy.getEnergyStored()) {
            tile.oldEnergy = tile.energy.getEnergyStored();
            if (!mark) {
                mark = true;
            }
        }
        if (mark) {
            tile.markDirtyAndDispatch();
        }
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        BaseItemStackHandler inventory = new BaseItemStackHandler(3, onContentsChanged);
        inventory.setOutputSlots(new int[]{0});
        inventory.setSlotValidator((slot, stack) -> slot == 1);
        return inventory;
    }

    public EnergyStorage getEnergy() {
        return this.energy;
    }

    public ItemStack getMaterialStack() {
        return this.materialStack;
    }

    public boolean hasMaterialStack() {
        return !this.materialStack.m_41619_();
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void toggleEjecting() {
        if (this.materialCount > 0) {
            this.ejecting = !this.ejecting;
            this.markDirtyAndDispatch();
        }
    }

    public boolean isLimitingInput() {
        return this.inputLimit;
    }

    public void toggleInputLimit() {
        this.inputLimit = !this.inputLimit;
        this.markDirtyAndDispatch();
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public CompressorRecipe getActiveRecipe() {
        return this.recipe;
    }

    public int getEnergyRequired() {
        if (this.hasRecipe()) {
            return this.recipe.getPowerCost();
        }
        return 0;
    }

    public int getMaterialsRequired() {
        if (this.hasRecipe()) {
            return this.recipe.getInputCount();
        }
        return 0;
    }

    private void process(CompressorRecipe recipe) {
        int extract = recipe.getPowerRate();
        int difference = recipe.getPowerCost() - this.progress;
        if (difference < extract) {
            extract = difference;
        }
        int extracted = this.energy.extractEnergy(extract, false);
        this.progress += extracted;
    }

    private void updateResult(ItemStack stack) {
        ItemStack result = this.inventory.getStackInSlot(0);
        if (result.m_41619_()) {
            this.inventory.setStackInSlot(0, stack);
        } else {
            this.inventory.setStackInSlot(0, StackHelper.grow((ItemStack)result, (int)stack.m_41613_()));
        }
    }
}

